// Landscape.cpp: Implementierung der Klasse CLandscape.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Landscape.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// Conversion factor for converting between degrees and radians
#define PI_OVER_180 0.0174532925f

// Array index for axis
const int x = 0;
const int y = 1;
const int z = 2;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CLandscape::CLandscape()
{
	// Init all member variables to default values
	m_Brightness     = 0.45f;
	m_CX             = 0.251f;
	m_CY             = 0.00002f;
	m_Limit          = (unsigned long) 1E5;
	m_StepSize       = 0.045f;
	m_XMin           = -2.0f;
	m_XMax           = 2.0f;
	m_YMin           = -2.0f;
	m_YMax           = 2.0f;
	m_IterationDepth = 450;
	m_TriangleCount  = 0;
	m_MinimumHeight  = 0.14f;

	// Set triangle array pointer
	m_Triangles = new CTriangle[ARRAY_SIZE * ARRAY_SIZE * 2];
}

CLandscape::~CLandscape()
{
	// Delete triangle array
	delete [] m_Triangles;
	m_Triangles = 0;
}

void CLandscape::GenerateLandscape(int iListIndex)
{
	// Render the landscape into a display list

	// Calculate landscape

	// Array that hold surface height data
	float fSurface[ARRAY_SIZE][ARRAY_SIZE];

	// Array dimension variables
	short int iArrayWidth;
	short int iArrayHeight;

	// Pass array dimension and surface array by reference
	CalculateFractalLandscape(iArrayWidth, iArrayHeight, fSurface);
	
	// Draw surface and generate collision data

	// Save passed list index
	m_LandscapeList = iListIndex;

	// Use passed display list index
	glNewList(m_LandscapeList, GL_COMPILE);

		// Set winding to clock-wise
		glFrontFace(GL_CW);

		// Use landscape texture
		m_Texture.Use();
		
		// Set the triangle vertices based on the surface array
		glBegin(GL_TRIANGLES);

			// Loop trough the whole surface array
			for (int iY=0; iY<=iArrayHeight - 1; iY++)
			{
				for (int iX=0; iX<=iArrayWidth - 1; iX++)
				{
					// Lower-left triangle
					
					// Calculate and set triangle vertices
					m_Triangles[m_TriangleCount].m_Vertices[0][0] = iY * m_StepSize + m_YMin;
					m_Triangles[m_TriangleCount].m_Vertices[0][1] = fSurface[iX][iY];
					m_Triangles[m_TriangleCount].m_Vertices[0][2] = iX * m_StepSize + m_XMin;
					m_Triangles[m_TriangleCount].m_Vertices[1][0] = (iY + 1) * m_StepSize + m_YMin;
					m_Triangles[m_TriangleCount].m_Vertices[1][1] = fSurface[iX][iY+1];
					m_Triangles[m_TriangleCount].m_Vertices[1][2] = iX * m_StepSize + m_XMin;
					m_Triangles[m_TriangleCount].m_Vertices[2][0] = (iY + 1) * m_StepSize + m_YMin;
					m_Triangles[m_TriangleCount].m_Vertices[2][1] = fSurface[iX+1][iY+1];
					m_Triangles[m_TriangleCount].m_Vertices[2][2] = (iX + 1) * m_StepSize + m_XMin;

					// Is at least one vertex of the triangle at the critical height above the ground ?
					if (IsAboveCriticalHeight(m_Triangles[m_TriangleCount].m_Vertices) == TRUE)
					{
						// Set all vertices that doesn't lay obove the minimum height to zero height
						SetBottomVertices(m_Triangles[m_TriangleCount].m_Vertices);
						
						// Calculate and set the normal for the triangle
						m_Triangles[m_TriangleCount].CalcNormal();
						glNormal3fv(m_Triangles[m_TriangleCount].m_Normal);

						// Calculate anti-planes for that triangle
						m_Triangles[m_TriangleCount].CalcAntiPlanes();

						// Set colors, vertices and texture coordinates
						glColor3f((float) fabs(m_Triangles[m_TriangleCount].m_Vertices[0][1] / m_YMax) +
							m_Brightness, m_Triangles[m_TriangleCount].m_Vertices[0][2] + m_Brightness,
							(float) fabs(m_Triangles[m_TriangleCount].m_Vertices[0][0] / m_XMax) + m_Brightness);
						glTexCoord2f(1.0f, 0.0f);
						glVertex3fv(m_Triangles[m_TriangleCount].m_Vertices[0]);
						glColor3f((float) fabs(m_Triangles[m_TriangleCount].m_Vertices[1][1] / m_YMax) +
							m_Brightness, m_Triangles[m_TriangleCount].m_Vertices[1][2] + m_Brightness,
							(float) fabs(m_Triangles[m_TriangleCount].m_Vertices[1][0] / m_XMax) + m_Brightness);
						glTexCoord2f(0.0f, 0.0f);
						glVertex3fv(m_Triangles[m_TriangleCount].m_Vertices[1]);
						glColor3f((float) fabs(m_Triangles[m_TriangleCount].m_Vertices[2][1] / m_YMax) +
							m_Brightness, m_Triangles[m_TriangleCount].m_Vertices[2][2] + m_Brightness,
							(float) fabs(m_Triangles[m_TriangleCount].m_Vertices[2][0] / m_XMax) + m_Brightness);
						glTexCoord2f(0.0f, 1.0f);
						glVertex3fv(m_Triangles[m_TriangleCount].m_Vertices[2]);

						// Increment array index (triangle count)
						m_TriangleCount++;
					}

					// Upper right triangle

					// Calculate and set triangle vertices
					m_Triangles[m_TriangleCount].m_Vertices[0][0] = iY * m_StepSize + m_YMin;
					m_Triangles[m_TriangleCount].m_Vertices[0][1] = fSurface[iX][iY];
					m_Triangles[m_TriangleCount].m_Vertices[0][2] = iX * m_StepSize + m_XMin;
					m_Triangles[m_TriangleCount].m_Vertices[1][0] = (iY + 1) * m_StepSize + m_YMin;
					m_Triangles[m_TriangleCount].m_Vertices[1][1] = fSurface[iX+1][iY+1];
					m_Triangles[m_TriangleCount].m_Vertices[1][2] = (iX + 1) * m_StepSize + m_XMin;
					m_Triangles[m_TriangleCount].m_Vertices[2][0] = iY * m_StepSize + m_YMin;
					m_Triangles[m_TriangleCount].m_Vertices[2][1] = fSurface[iX+1][iY];
					m_Triangles[m_TriangleCount].m_Vertices[2][2] = (iX + 1) * m_StepSize + m_XMin;

					// Is at least one vertex of the triangle at the critical height above the ground ?
					if (IsAboveCriticalHeight(m_Triangles[m_TriangleCount].m_Vertices) == TRUE)
					{
						// Set all vertices that doesn't lay obove the minimum height to zero height
						SetBottomVertices(m_Triangles[m_TriangleCount].m_Vertices);

						// Calculate and set the normal for the triangle
						m_Triangles[m_TriangleCount].CalcNormal();
						glNormal3fv(m_Triangles[m_TriangleCount].m_Normal);

						// Calculate anti-planes for that triangle
						m_Triangles[m_TriangleCount].CalcAntiPlanes();

						// Set colors, vertices and texture coordinates
						glColor3f((float) fabs(m_Triangles[m_TriangleCount].m_Vertices[0][1] / m_YMax) + 
							m_Brightness, m_Triangles[m_TriangleCount].m_Vertices[0][2] + m_Brightness,
							(float) fabs(m_Triangles[m_TriangleCount].m_Vertices[0][0] / m_XMax) + m_Brightness);
						glTexCoord2f(1.0f, 0.0f);
						glVertex3fv(m_Triangles[m_TriangleCount].m_Vertices[0]);
						glColor3f((float) fabs(m_Triangles[m_TriangleCount].m_Vertices[1][1] / m_YMax) + 
							m_Brightness, m_Triangles[m_TriangleCount].m_Vertices[1][2] + m_Brightness,
							(float) fabs(m_Triangles[m_TriangleCount].m_Vertices[1][0] / m_XMax) + m_Brightness);
						glTexCoord2f(0.0f, 1.0f);
						glVertex3fv(m_Triangles[m_TriangleCount].m_Vertices[1]);
						glColor3f((float) fabs(m_Triangles[m_TriangleCount].m_Vertices[2][1] / m_YMax) + 
							m_Brightness, m_Triangles[m_TriangleCount].m_Vertices[2][2] + m_Brightness,
							(float) fabs(m_Triangles[m_TriangleCount].m_Vertices[2][0] / m_XMax) + m_Brightness);
						glTexCoord2f(1.0f, 1.0f);
						glVertex3fv(m_Triangles[m_TriangleCount].m_Vertices[2]);

						// Increment array index (triangle count)
						m_TriangleCount++;
					}
				}
			}

		glEnd();

	glEndList();

	// Decrement triangle count, because the counter was incremented
	// once to often
	--m_TriangleCount;
}

void CLandscape::CalculateFractalLandscape(short int &iArrayWidth, short int &iArrayHeight, float fSurface[][ARRAY_SIZE])
{
	// Calculate the landscape and fill results into the surface array. The
	// array and its dimensions are calculated and passed back by reference

	// Start with a fresh col
	iArrayWidth = -1;

	// Loop trough x- and y-axis
	for (float x=m_XMin; x<=m_XMax; x+=m_StepSize)
	{
		// Inkrement width of array
		++iArrayWidth;

		// Start with a fresh row
		iArrayHeight = -1;

		for (float y=m_YMin; y<=m_YMax; y+=m_StepSize)
		{
			// Declare / reset iteration variables
			float xIterate = x;	
			float yIterate = y;
			float yPow2 = 0.0f;
							
			// Inkrement height of array
			++iArrayHeight;

			// Calculate if point belongs to the Julia set
			for (int iDepth=0; iDepth<=m_IterationDepth; iDepth++)
			{
				// Calculate yIterate before (!) calculate the new (n+1) yIterate
				yPow2 = (yIterate * yIterate);

				// It is important to calculate yIterate first,
				// because the xIterate index must be n, not n+1
				yIterate = 2 * xIterate * yIterate + m_CY;
 
				// Take the pre-calculated yPow2. Otherwise we would
				// calculate yIterate(n+1)
				xIterate = (xIterate * xIterate) - yPow2 + m_CX;

				// If iteration value will raise to infinite or if the maximum depth
				// has been reached (point belongs to the Julia set)
				if (xIterate > m_Limit || yIterate > m_Limit || iDepth == m_IterationDepth)
				{
					// Set calculated z coordinate (which is taken from the iteration depth,
					// maximum is limited to 0.66)
					fSurface[iArrayWidth][iArrayHeight] = iDepth / (float) m_IterationDepth / 1.5f;
										
					// Don't set array twice / don't perform more steps
					break;
				}
			}
		}
	}
}

bool CLandscape::IsAboveCriticalHeight(float fTriangle[][3])
{
	// Checks if at least one vertex of the triangle is above the critical height
	
	// Check height
	if (fTriangle[0][1] > m_MinimumHeight ||
		fTriangle[1][1] > m_MinimumHeight ||
		fTriangle[2][1] > m_MinimumHeight)
		return TRUE; // Yes
	
	// No
	return FALSE;
}

void CLandscape::SetBottomVertices(float fTriangle[][3])
{
	// Set all vertices that doesn't lay obove the minimum height
	// to zero height

	if (fTriangle[0][1] < m_MinimumHeight)
		fTriangle[0][1] = 0.0f;
	if (fTriangle[1][1] < m_MinimumHeight)
		fTriangle[1][1] = 0.0f;
	if (fTriangle[2][1] < m_MinimumHeight)
		fTriangle[2][1] = 0.0f;
}

void CLandscape::DrawLandscape()
{
	// Call display list for the landscape
	glCallList(m_LandscapeList);
}